const { z } = require('zod');
const paymentService = require('../services/paymentService');
const orderService = require('../services/orderService');

const depositSchema = z.object({
  amount: z.number().positive(),
  method: z.enum(['QRIS', 'EWALLET']),
});

async function createDeposit(req, res, next) {
  try {
    const payload = depositSchema.parse(req.body);
    const result = await paymentService.createDepositPayment({
      user: req.user,
      amount: payload.amount,
      method: payload.method,
    });
    res.json(result);
  } catch (err) {
    next(err);
  }
}

async function checkStatus(req, res, next) {
  try {
    const paymentId = req.params.paymentId;
    const depositResult = await paymentService.handleDepositStatus(paymentId);
    const orderResult = await orderService.handlePaymentStatus(paymentId);
    res.json({
      deposit: depositResult,
      order: orderResult,
    });
  } catch (err) {
    next(err);
  }
}

async function cancel(req, res, next) {
  try {
    const paymentId = req.params.paymentId;
    const result = await paymentService.cancelDepositPayment(paymentId);
    res.json(result);
  } catch (err) {
    next(err);
  }
}

module.exports = {
  createDeposit,
  checkStatus,
  cancel,
};
