const { verifyToken } = require('../utils/jwt');
const prisma = require('../prisma');
const { createError } = require('../utils/errors');

async function requireAdminAuth(req, res, next) {
  try {
    const header = req.headers.authorization || '';
    const token = header.startsWith('Bearer ') ? header.slice(7) : null;
    if (!token) {
      throw createError(401, 'Unauthorized');
    }
    const payload = verifyToken(token);
    if (!payload.admin) {
      throw createError(403, 'Forbidden');
    }
    const admin = await prisma.adminUser.findUnique({ where: { id: payload.sub } });
    if (!admin) {
      throw createError(401, 'Unauthorized');
    }
    req.admin = admin;
    next();
  } catch (err) {
    next(err.status ? err : createError(401, 'Unauthorized'));
  }
}

module.exports = { requireAdminAuth };
