require('dotenv').config();
const app = require('./app');
const prisma = require('./prisma');
const { ensureSettings } = require('./services/settingsService');

const port = process.env.PORT || 3000;

async function start() {
  try {
    await prisma.$connect();
    await ensureSettings();
    app.listen(port, () => {
      console.log(`MENVORA backend running on port ${port}`);
    });
  } catch (err) {
    console.error('Failed to start server:', err);
    process.exit(1);
  }
}

start();
