const { Prisma } = require('@prisma/client');

function toDecimal(value) {
  if (value instanceof Prisma.Decimal) {
    return value;
  }
  return new Prisma.Decimal(value || 0);
}

function applyPercent(amount, percent) {
  const base = toDecimal(amount);
  const pct = toDecimal(percent).div(100);
  return base.mul(pct);
}

module.exports = { toDecimal, applyPercent };
