(async function () {
  const existingToken = getToken();
  if (existingToken) {
    window.location.href = 'home.html';
    return;
  }

  const urlParams = new URLSearchParams(window.location.search);
  const oauthToken = urlParams.get('token');
  if (oauthToken) {
    setToken(oauthToken);
    const cleanUrl = new URL(window.location.href);
    cleanUrl.searchParams.delete('token');
    window.history.replaceState({}, document.title, cleanUrl.toString());
    window.location.href = 'home.html';
    return;
  }

  const resetToken = urlParams.get('reset_token');
  if (resetToken) {
    try {
      await handleReset(resetToken);
      const cleanUrl = new URL(window.location.href);
      cleanUrl.searchParams.delete('reset_token');
      window.history.replaceState({}, document.title, cleanUrl.toString());
      alert('Password berhasil direset. Silakan login.');
    } catch (err) {
      alert(err.message || 'Reset password gagal.');
    }
  }

  const form = document.querySelector('form');
  const signupLink = document.querySelector('.button-page a[href]');
  if (signupLink) {
    signupLink.setAttribute('href', 'register.html');
  }

  const googleLink = document.querySelector('a.google');
  if (googleLink) {
    googleLink.setAttribute('href', `${API_BASE}/api/auth/google`);
  }

  const forgotLink = document.querySelector('.forgot-password');
  if (forgotLink) {
    forgotLink.addEventListener('click', async (event) => {
      event.preventDefault();
      const email = prompt('Masukkan email akun Anda:');
      if (!email) return;
      try {
        const result = await apiFetch('/api/auth/forgot-password', {
          method: 'POST',
          body: JSON.stringify({ email }),
        });
        if (result.reset_token) {
          await handleReset(result.reset_token);
          alert('Password berhasil direset. Silakan login.');
        } else {
          alert('Jika email terdaftar, link reset telah dikirim.');
        }
      } catch (err) {
        alert(err.message || 'Gagal memproses reset password.');
      }
    });
  }

  if (!form) return;

  form.addEventListener('submit', async (event) => {
    event.preventDefault();
    const email = form.querySelector('input[name="email"]')?.value?.trim();
    const password = form.querySelector('input[name="password"]')?.value;
    if (!email || !password) {
      alert('Email dan password wajib diisi.');
      return;
    }
    try {
      const result = await apiFetch('/api/auth/login', {
        method: 'POST',
        body: JSON.stringify({ email, password }),
      });
      setToken(result.token);
      window.location.href = 'home.html';
    } catch (err) {
      alert(err.message || 'Login gagal');
    }
  });
})();

async function handleReset(token) {
  const newPassword = prompt('Masukkan password baru:');
  if (!newPassword) {
    throw new Error('Password baru wajib diisi.');
  }
  const confirmPassword = prompt('Ulangi password baru:');
  if (newPassword !== confirmPassword) {
    throw new Error('Password tidak sama.');
  }
  await apiFetch('/api/auth/reset-password', {
    method: 'POST',
    body: JSON.stringify({ token, newPassword }),
  });
}
