(async function () {
  const existingToken = getToken();
  if (existingToken) {
    window.location.href = 'home.html';
    return;
  }
  const form = document.querySelector('form');
  const signinLink = document.querySelector('.button-page a[href]');
  if (signinLink) {
    signinLink.setAttribute('href', 'login.html');
  }

  const googleLink = document.querySelector('a.google');
  if (googleLink) {
    googleLink.setAttribute('href', `${API_BASE}/api/auth/google`);
  }

  if (!form) return;

  form.addEventListener('submit', async (event) => {
    event.preventDefault();
    const name = form.querySelector('input[name="nama_lengkap"]')?.value?.trim();
    const email = form.querySelector('input[name="email"]')?.value?.trim();
    const phone = form.querySelector('input[name="nomor_hp"]')?.value?.trim();
    const password = form.querySelector('input[name="password"]')?.value;
    if (!name || !email || !password) {
      alert('Nama, email, dan password wajib diisi.');
      return;
    }
    try {
      const result = await apiFetch('/api/auth/register', {
        method: 'POST',
        body: JSON.stringify({ name, email, phone, password }),
      });
      setToken(result.token);
      window.location.href = 'home.html';
    } catch (err) {
      alert(err.message || 'Registrasi gagal');
    }
  });
})();
