const CATEGORY_LABELS = {
  game: 'Daftar Game',
  pulsa: 'Pulsa',
  token_pln: 'Token PLN',
  axis: 'Axis',
  indosat: 'Indosat',
  smartfren: 'Smartfren',
  telkomsel: 'Telkomsel',
  three: 'Three',
  xl: 'XL',
  ewallet: 'E-Wallet',
  tagihan_listrik: 'Tagihan Listrik',
  tagihan_gas: 'Tagihan Gas',
  tagihan_bpjs: 'Tagihan BPJS',
  tagihan_pdam: 'Tagihan PDAM',
  tagihan_pbb: 'Tagihan PBB',
  tagihan_internet: 'Tagihan Internet',
  nokos: 'Nokos',
  whatsapp: 'Kebutuhan WhatsApp',
  hosting: 'Kebutuhan Hosting',
  musik: 'Musik',
  save_id: 'Save ID',
  voucher: 'Voucher',
};

const CATEGORY_GAMES = {
  // Isi dengan kode game dari apigames jika ingin kategori tersebut menampilkan produk.
  // Contoh:
  // pulsa: ['pulsa_telkomsel', 'pulsa_xl'],
  game: null,
  pulsa: [],
  token_pln: [],
  axis: [],
  indosat: [],
  smartfren: [],
  telkomsel: [],
  three: [],
  xl: [],
  ewallet: [],
  tagihan_listrik: [],
  tagihan_gas: [],
  tagihan_bpjs: [],
  tagihan_pdam: [],
  tagihan_pbb: [],
  tagihan_internet: [],
  nokos: [],
  whatsapp: [],
  hosting: [],
  musik: [],
  save_id: [],
  voucher: [],
};

const CATEGORY_KEYWORDS = {
  pulsa: ['pulsa', 'topup', 'isi ulang', 'telkomsel', 'indosat', 'xl', 'axis', 'three', 'tri', 'smartfren'],
  token_pln: ['token', 'pln', 'listrik'],
  axis: ['axis'],
  indosat: ['indosat', 'im3'],
  smartfren: ['smartfren'],
  telkomsel: ['telkomsel'],
  three: ['three', 'tri'],
  xl: ['xl'],
  ewallet: ['dana', 'ovo', 'gopay', 'gopay', 'linkaja', 'shopee', 'shopeepay', 'isaku', 'sakuku'],
  tagihan_listrik: ['listrik', 'pln', 'tagihan'],
  tagihan_gas: ['gas', 'pgn', 'tagihan'],
  tagihan_bpjs: ['bpjs', 'tagihan'],
  tagihan_pdam: ['pdam', 'tagihan'],
  tagihan_pbb: ['pbb', 'tagihan'],
  tagihan_internet: ['internet', 'wifi', 'indihome', 'biznet', 'myrepublic', 'tagihan'],
  nokos: ['nokos'],
  whatsapp: ['whatsapp', 'wa'],
  hosting: ['hosting', 'domain', 'vps', 'server'],
  musik: ['musik', 'spotify', 'joox', 'music'],
  save_id: ['save id', 'saveid'],
  voucher: ['voucher', 'gift', 'kode', 'code'],
};

const CATEGORY_ALLOW_FALLBACK = true;

const CATEGORY_FORM = {
  // true = tampilkan form ID/Server, false = sembunyikan form
  game: true,
  pulsa: false,
  token_pln: false,
  axis: false,
  indosat: false,
  smartfren: false,
  telkomsel: false,
  three: false,
  xl: false,
  ewallet: false,
  tagihan_listrik: false,
  tagihan_gas: false,
  tagihan_bpjs: false,
  tagihan_pdam: false,
  tagihan_pbb: false,
  tagihan_internet: false,
  nokos: false,
  whatsapp: false,
  hosting: false,
  musik: false,
  save_id: false,
  voucher: false,
};

window.CATEGORY_LABELS = CATEGORY_LABELS;
window.CATEGORY_GAMES = CATEGORY_GAMES;
window.CATEGORY_KEYWORDS = CATEGORY_KEYWORDS;
window.CATEGORY_ALLOW_FALLBACK = CATEGORY_ALLOW_FALLBACK;
window.CATEGORY_FORM = CATEGORY_FORM;
