(function () {
  const token = getToken();
  if (!token) {
    window.location.href = 'login.html';
    return;
  }

  const cards = document.querySelectorAll('.card');
  if (!cards.length) return;

  function attach(card, method) {
    const link = card.closest('a');
    if (!link) return;
    link.addEventListener('click', async (event) => {
      event.preventDefault();
      const amount = await requestAmount({
        title: 'Masukkan nominal deposit',
        hint: 'Nominal dalam angka saja',
        confirmText: 'Lanjutkan',
      });
      if (!amount) return;
      try {
        const payment = await apiFetch('/api/payments/deposit', {
          method: 'POST',
          body: JSON.stringify({ amount, method }),
        });
        const storageKey = `menvora_payment_${payment.payment_id}`;
        localStorage.setItem(storageKey, JSON.stringify(payment));
        window.location.href = `deposit.html?payment_id=${encodeURIComponent(payment.payment_id)}&method=${method}`;
      } catch (err) {
        alert(err.message || 'Gagal membuat pembayaran.');
      }
    });
  }

  if (cards[0]) attach(cards[0], 'QRIS');
  if (cards[2]) attach(cards[2], 'EWALLET');
})();
