(async function () {
  try {
    const token = getToken();
    if (!token) {
      window.location.href = 'login.html';
      return;
    }

    const params = new URLSearchParams(window.location.search);
    const bodyCategory = document.body?.dataset?.category;
    const category = (bodyCategory || params.get('category') || 'game').toLowerCase();
    const label = (window.CATEGORY_LABELS && window.CATEGORY_LABELS[category]) || 'Daftar Game';
    const categoryGames = window.CATEGORY_GAMES ? window.CATEGORY_GAMES[category] : null;
    const defaultKeywords = {
      pulsa: ['pulsa', 'topup', 'isi ulang', 'telkomsel', 'indosat', 'xl', 'axis', 'three', 'tri', 'smartfren'],
      token_pln: ['token', 'pln', 'listrik'],
      axis: ['axis'],
      indosat: ['indosat', 'im3'],
      smartfren: ['smartfren'],
      telkomsel: ['telkomsel'],
      three: ['three', 'tri'],
      xl: ['xl'],
      ewallet: ['dana', 'ovo', 'gopay', 'linkaja', 'shopee', 'shopeepay', 'isaku', 'sakuku'],
      tagihan_listrik: ['listrik', 'pln', 'tagihan'],
      tagihan_gas: ['gas', 'pgn', 'tagihan'],
      tagihan_bpjs: ['bpjs', 'tagihan'],
      tagihan_pdam: ['pdam', 'tagihan'],
      tagihan_pbb: ['pbb', 'tagihan'],
      tagihan_internet: ['internet', 'wifi', 'indihome', 'biznet', 'myrepublic', 'tagihan'],
      nokos: ['nokos'],
      whatsapp: ['whatsapp', 'wa'],
      hosting: ['hosting', 'domain', 'vps', 'server'],
      musik: ['musik', 'spotify', 'joox', 'music'],
      save_id: ['save id', 'saveid'],
      voucher: ['voucher', 'gift', 'kode', 'code'],
    };
    const categoryKeywords = (window.CATEGORY_KEYWORDS && window.CATEGORY_KEYWORDS[category]) || defaultKeywords[category] || [];
    const allowFallback = window.CATEGORY_ALLOW_FALLBACK !== false;
    const showForm = category === 'game' || (window.CATEGORY_FORM && window.CATEGORY_FORM[category] === true);

    const textTop = document.getElementById('textTop');
    if (textTop) textTop.textContent = label;
    const imgTop = document.getElementById('imgTop');
    if (imgTop) {
      imgTop.src = 'assets/icons/topup.svg';
      imgTop.classList.remove('u-bg', 'p-1');
    }

    const formSection = document.getElementById('nomoId')?.closest('section');
    if (formSection && !showForm) {
      formSection.classList.add('d-none');
    }
    const boxPilihan = document.getElementById('boxPilihan');
    if (boxPilihan && !showForm) {
      boxPilihan.classList.add('d-none');
    }

    const container = document.getElementById('dataProduk');
    if (!container) return;

    const res = await apiFetch('/api/games');
    let games = res.data || [];
    if (Array.isArray(categoryGames) && categoryGames.length) {
      const lookup = new Set(categoryGames);
      games = games.filter((game) => lookup.has(game.code));
    } else if (category !== 'game' && allowFallback && Array.isArray(categoryKeywords) && categoryKeywords.length) {
      const keywords = categoryKeywords.map((k) => k.toLowerCase());
      games = games.filter((game) => {
        const haystack = `${game.code || ''} ${game.name || ''}`.toLowerCase();
        return keywords.some((k) => haystack.includes(k));
      });
    } else if (category !== 'game') {
      games = [];
    }

    const allGames = games;
    let searchTerm = '';
    let sortMode = null;

    const searchInput = document.getElementById('search');
    if (searchInput) {
      searchInput.addEventListener('input', (event) => {
        searchTerm = event.target.value.trim().toLowerCase();
        applyFilters();
      });
    }

    window.rubahData = function rubahData(mode) {
      sortMode = mode;
      applyFilters();
    };

    window.rubahTampilan = function rubahTampilan() {};
    window.rubahGambar = function rubahGambar() {};
    window.rubahPencarian = function rubahPencarian() {};
    window.rubahSrcPil = function rubahSrcPil() {};

    function applyFilters() {
      if (!allGames.length) {
        container.innerHTML = '<p class="text-center mt-3">Produk belum tersedia.</p>';
        return;
      }
      let filtered = allGames;
      if (searchTerm) {
        filtered = filtered.filter((game) => {
          const haystack = `${game.name || ''} ${game.code || ''}`.toLowerCase();
          return haystack.includes(searchTerm);
        });
      }
      filtered = sortGames(filtered, sortMode);
      if (!filtered.length) {
        container.innerHTML = '<p class="text-center mt-3">Produk tidak ditemukan.</p>';
        return;
      }
      renderGames(filtered);
    }

    function sortGames(list, mode) {
      const copy = [...list];
      if (mode === 'A-Z') {
        return copy.sort((a, b) => String(a.name || '').localeCompare(String(b.name || '')));
      }
      if (mode === 'Z-A') {
        return copy.sort((a, b) => String(b.name || '').localeCompare(String(a.name || '')));
      }
      return copy;
    }

    function renderGames(list) {
      container.innerHTML = '<div class="animate__animated animate__fadeIn d-grid-2" id="gameList"></div>';
      const listEl = document.getElementById('gameList');
      list.forEach((game) => {
        const card = document.createElement('div');
        card.className = 'bg-produk animate__animated animate__flipInX';
        card.innerHTML = `
          <div class="box-utama box-grid">
            <img src="${game.iconUrl || 'assets/icons/placeholder.svg'}" class="box-img borad-5 mb-3" width="40">
            <div class="text-start">
              <p class="fwb-6">${game.name}</p>
              <p class="fwb-6 op-7">${game.code}</p>
              <p class="fwb-6 f-14 u-color">Top Up</p>
            </div>
          </div>
        `;
        card.addEventListener('click', () => {
          window.location.href = `game_detail.html?game=${encodeURIComponent(game.code)}`;
        });
        listEl.appendChild(card);
      });
    }

    applyFilters();
  } catch (err) {
    console.error(err);
    alert(err.message || 'Gagal memuat game.');
  }
})();

function getGaleri() {
  const input = document.getElementById('fileInput');
  if (input) {
    input.click();
  }
  return false;
}

async function previewImage(event) {
  const file = event?.target?.files?.[0];
  if (!file) return;

  const ocrInfo = document.getElementById('ocrInfo');
  const ocrResult = document.getElementById('ocrResult');
  if (ocrInfo) {
    ocrInfo.classList.remove('d-none');
    ocrInfo.textContent = 'Memeriksa gambar...';
  }
  if (ocrResult) {
    ocrResult.innerHTML = '';
  }

  if (!window.Tesseract) {
    if (ocrInfo) ocrInfo.textContent = 'OCR tidak tersedia.';
    return;
  }

  try {
    const result = await window.Tesseract.recognize(file, 'eng');
    const rawText = result?.data?.text || '';
    const cleaned = rawText.replace(/[^0-9\\n]/g, ' ').replace(/\\s+/g, ' ').trim();
    if (!cleaned) {
      if (ocrInfo) ocrInfo.textContent = 'Tidak ada angka terdeteksi.';
      return;
    }
    const values = Array.from(new Set(cleaned.split(' ').filter(Boolean))).slice(0, 6);
    if (ocrInfo) ocrInfo.textContent = 'Hasil OCR:';
    if (ocrResult) {
      ocrResult.innerHTML = '';
      values.forEach((val) => {
        const btn = document.createElement('button');
        btn.type = 'button';
        btn.className = 'pill-button';
        btn.textContent = val;
        btn.addEventListener('click', () => {
          const input = document.getElementById('nomoId');
          if (input) input.value = val;
        });
        ocrResult.appendChild(btn);
      });
    }
    const input = document.getElementById('nomoId');
    if (input && values[0]) {
      input.value = values[0];
    }
  } catch (err) {
    if (ocrInfo) ocrInfo.textContent = 'Gagal membaca gambar.';
  }
}
