(async function () {
  const token = getToken();
  if (!token) {
    window.location.href = 'login.html';
    return;
  }

  const profileForm = document.getElementById('profileForm');
  const passwordForm = document.getElementById('passwordForm');
  const logoutBtn = document.getElementById('logoutBtn');

  try {
    const profile = await apiFetch('/api/me');
    if (profileForm) {
      const nameInput = profileForm.querySelector('input[name="name"]');
      const emailInput = profileForm.querySelector('input[name="email"]');
      const phoneInput = profileForm.querySelector('input[name="phone"]');
      if (nameInput) nameInput.value = profile.name || '';
      if (emailInput) emailInput.value = profile.email || '';
      if (phoneInput) phoneInput.value = profile.phone || '';
    }
  } catch (err) {
    clearToken();
    window.location.href = 'login.html';
    return;
  }

  if (profileForm) {
    profileForm.addEventListener('submit', async (event) => {
      event.preventDefault();
      const name = profileForm.querySelector('input[name="name"]')?.value?.trim();
      const email = profileForm.querySelector('input[name="email"]')?.value?.trim();
      const phone = profileForm.querySelector('input[name="phone"]')?.value?.trim();
      if (!name || !email) {
        alert('Nama dan email wajib diisi.');
        return;
      }
      try {
        await apiFetch('/api/me', {
          method: 'PATCH',
          body: JSON.stringify({ name, email, phone }),
        });
        alert('Profil berhasil disimpan.');
      } catch (err) {
        alert(err.message || 'Gagal menyimpan profil.');
      }
    });
  }

  if (passwordForm) {
    passwordForm.addEventListener('submit', async (event) => {
      event.preventDefault();
      const currentPassword = passwordForm.querySelector('input[name="currentPassword"]')?.value;
      const newPassword = passwordForm.querySelector('input[name="newPassword"]')?.value;
      const confirmPassword = passwordForm.querySelector('input[name="confirmPassword"]')?.value;
      if (!currentPassword || !newPassword || !confirmPassword) {
        alert('Semua field password wajib diisi.');
        return;
      }
      if (newPassword !== confirmPassword) {
        alert('Password baru tidak sama.');
        return;
      }
      try {
        await apiFetch('/api/me/password', {
          method: 'PATCH',
          body: JSON.stringify({ currentPassword, newPassword }),
        });
        passwordForm.reset();
        alert('Password berhasil diubah.');
      } catch (err) {
        alert(err.message || 'Gagal mengubah password.');
      }
    });
  }

  if (logoutBtn) {
    logoutBtn.addEventListener('click', () => {
      clearToken();
      window.location.href = 'index.html';
    });
  }
})();
